package org.mule.modules.sunsetrise.api;

import java.net.URL;

import org.mule.api.ConnectionException;

public class SunSetRiseProxyClient {

	private SunSetRiseServiceSoap port;

	public SunSetRiseProxyClient() {
	}

	public void initialize() throws ConnectionException {
		SunSetRiseService svc;
		// pick up the WSDL from the location in the JAR
		URL url = SunSetRiseService.class.getClassLoader().getResource(
				"wsdl/sunsetriseservice.wsdl");
		svc = new SunSetRiseService(url);

		port = svc.getSunSetRiseServiceSoap();

		// Configure Authentication headers here, if the service uses them.
		// Add parameters as needed to initialize() to pass them
		// in from your connector
	}

	public LatLonDate getSunSetRiseTime(LatLonDate in) {
		return port.getSunSetRiseTime(in);
	}
}
