Microsft Dynamics 365 Connector Demo
=======================================

INTRODUCTION
------------
This demo is going to demonstrate the use of Microsft Dynamics 365 Connector.


HOW TO RUN DEMO
---------------

### Prerequisites

In order to build and run this demo project you'll need:

* Anypoint Studio with at least Mule ESB 3.5 Runtime.
* Microsft Dynamics 365 Connector v1.0.0 or higher.
* Dynamics 365 (CRM 8.2)

### Test the Flows

1. Import the demo project into your workspace via "Anypoint Exchange" or "Import..." from "File" menu.
2. Specify your OAuth2 credentials for 'OAuth2 Username Password' Config in /src/main/app/mule-app.properties

	* `dynamics365.username` - Username used to initialize the session
	* `dynamics365.password` - Password used to authenticate the user
	* `dynamics365.resource` - The App ID URI of the web API (secured resource). It must be root URI, without specifing the CRM version (Example: `https://<your-org>.crm2.dynamics.com/`)
	* `dynamics365.clientId` - The Application Id assigned to your app when you registered it with Azure AD. You can find this in the Azure Portal. Click Active Directory, click the directory, choose the application, and click Configure.
	* `dynamics365.clientSecret` - The Application Secret that you created in the app registration portal for your app. It should not be used in a native app, because client_secrets cannot be reliably stored on devices. It is required for web apps and web APIs, which have the ability to store the client_secret securely on the server side.
	* `dynamics365.tokenRequestEndpoint` - The token endpoint that is called to get the access token. (Example: `https://login.windows.net/<tenant-id>/oauth2/token` where 'tenant-id' is the Azure AD id)


3. Make sure you specify 'DataSense Connection Timeout' with more than 200 seconds because the connector makes several requests to provide DataSense information.
	
4. Run the project in Studio.
5. Type `localhost:8081` in your browser to access the selection menu of the demo.
6. Optionally you can configure the Connection Timeout and Read Timeout. 
	The Connection Timeout is the timeout in making the initial connection with the server. 
	The Read Timeout is the timeout on waiting to read data from the server.
	
	
About the Demo
---------------
	
1. `CREATE_EMPTY_CONTACT_DEMO`: This flow creates an empty contact entity that is required later in other flows.

	[GET] The HTTP endpoint listens to the following URL: `http://localhost:8081/createContact`

2. `CREATE_EMPTY_OPPORTUNITY_DEMO`: This flow creates an empty opportunity entity that is required later in other flows.

	[GET] The HTTP endpoint listens to the following URL: `http://localhost:8081/createOpportunity`

3. `CREATE_ACCOUNT_DEMO`: This flow creates an account with specified attributes and also associates the account with a contact.

	[POST] HTTP endpoint listens to the following URL: `http://localhost:8081/createAccount`

	Request example: `{"AccountName":"Test Account Name","CreditOnHold":true,"CreditLimit":1000,"ContactID":"6b7f3e8d-142f-e711-8107-c4346bb64010"}`

4. `CREATE_MULTIPLE_ENTITIES_DEMO`: This flow creates multiple entities of the same type in a single batch request.

	
	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/createMultipleAccounts`

	Request example: `[{"AccountName":"Account Name 1","CreditOnHold":true,"CreditLimit":1500},{"AccountName":"Account Name 2","CreditOnHold":false,"CreditLimit":2000}]`

5. `CREATE_MULTIPLE_ENTITIES_DEMO`: This flow creates multiple entities of the same type in a single batch request.

	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/createMultipleAccounts`

	Request example: `[{"AccountName":"Account Name 1","CreditOnHold":true,"CreditLimit":1500},{"AccountName":"Account Name 2","CreditOnHold":false,"CreditLimit":2000}]`
`
6. `UPDATE_ENTITY_DEMO`: This flow updates an account with specified attributes.

	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/updateAccount`

	Request example: `{"EntityId":"f817bc8d-142f-e711-80fc-c4346bb53e2c","AccountName":"Updated Name","CreditLimit":1500}`

7. `UPDATE_MULTIPLE_ENTITIES_DEMO`: This flow updated multiple entities of the same type in a single batch request.

	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/updateMultipleAccounts`

	Request example: `[{"EntityId":"f817bc8d-142f-e711-80fc-c4346bb53e2c","AccountName":"Updated Name 1"},{"EntityId":"1d0cd95a-56ff-e611-8100-c4346bb64014","AccountName":"Updated Name 2"}]`

8. `DELETE_ENTITY_DEMO`: This flow deletes an entity of a specified type.
[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/deleteAccount`

	Request example: `{"EntityId":"f817bc8d-142f-e711-80fc-c4346bb53e2c"}`

9. `RETRIEVE_ENTITY_DEMO`: This flow retrieves an entity of a specified type.

	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/retrieveAccount`

	Request example: `{"EntityId":"f817bc8d-142f-e711-80fc-c4346bb53e2c"}`

10. `RETRIEVE_ENTITIES_BY_URL_DEMO`: This flow retrieves multiple entities based on url request.

	[GET] The HTTP endpoint listens to the following URL: `http://localhost:8081/retrieveAccountsByURL`

11. `RETRIEVE_ENTITIES_BY_QUERY_DEMO`: This flow retrieves multiple entities based on Datasense Query Language.

	[GET] The HTTP endpoint listens to the following URL: `http://localhost:8081/retrieveAccountsByQuery`

12. `DISASSOCIATE_ENTITIES_DEMO`: This flow dissasociates entities. You provide the id of the entity upon which the request will be made and the keys that will be dissasociated.

	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/disassociateEntities`

	Request example: `{"EntityId":"f817bc8d-142f-e711-80fc-c4346bb53e2c","EntityLinkKeys":["primarycontactid"]}`

13. `DO_ACTION_DEMO`: This flow calls the WinOpportunity Action.

	[POST] The HTTP endpoint listens to the following URL: `http://localhost:8081/doAction`

	Request example: `{"Subject":"Won Opportunity","Status":3,"OpportunityId":"f43aecaf-332f-e711-8107-c4346bb64010"}`

You can use the selection menu from `http://localhost:8081` to test the flows or you can POST JSONs using a tool like curl, or any other tool (Chrome/Mozilla Firefox extensions) that lets you POST a body when calling the URL.