/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.config;

import org.mule.config.MuleManifest;
import org.mule.modules.security.encryption.adapters.EncryptionModuleLicenseChecker;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.XmlEncrypterConfiguration;
import org.mule.security.oauth.config.AbstractDevkitBasedDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanDefinitionParsingException;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class EncryptionModuleConfigDefinitionParser
extends AbstractDevkitBasedDefinitionParser {
    private static Logger logger = LoggerFactory.getLogger(EncryptionModuleConfigDefinitionParser.class);

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        this.parseConfigName(element);
        BeanDefinitionBuilder builder = this.getBeanDefinitionBuilder(parserContext);
        builder.setScope("singleton");
        this.setInitMethodIfNeeded(builder, EncryptionModuleLicenseChecker.class);
        this.setDestroyMethodIfNeeded(builder, EncryptionModuleLicenseChecker.class);
        this.parseProperty(builder, element, "defaultEncrypter", "defaultEncrypter");
        this.parseProperty(builder, element, "enableLanguage", "enableLanguage");
        if (!this.parseNoExprObjectRef(element, builder, "xml-encrypter-config", "xmlEncrypterConfig")) {
            BeanDefinitionBuilder xmlEncrypterConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)XmlEncrypterConfiguration.class.getName());
            Element xmlEncrypterConfigChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"xml-encrypter-config");
            if (xmlEncrypterConfigChildElement != null) {
                this.parseProperty(xmlEncrypterConfigBuilder, xmlEncrypterConfigChildElement, "key", "key");
                this.parseProperty(xmlEncrypterConfigBuilder, xmlEncrypterConfigChildElement, "keystorePath", "keystorePath");
                this.parseProperty(xmlEncrypterConfigBuilder, xmlEncrypterConfigChildElement, "keystorePassword", "keystorePassword");
                this.parseProperty(xmlEncrypterConfigBuilder, xmlEncrypterConfigChildElement, "keyPassword", "keyPassword");
                this.parseProperty(xmlEncrypterConfigBuilder, xmlEncrypterConfigChildElement, "xpath", "xpath");
                this.parseProperty(xmlEncrypterConfigBuilder, xmlEncrypterConfigChildElement, "algorithm", "algorithm");
                builder.addPropertyValue("xmlEncrypterConfig", (Object)xmlEncrypterConfigBuilder.getBeanDefinition());
            }
        }
        if (!this.parseNoExprObjectRef(element, builder, "jce-encrypter-config", "jceEncrypterConfig")) {
            BeanDefinitionBuilder jceEncrypterConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)JCEEncrypterConfiguration.class.getName());
            Element jceEncrypterConfigChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"jce-encrypter-config");
            if (jceEncrypterConfigChildElement != null) {
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "key", "key");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "usePublicKeyToEncrypt", "usePublicKeyToEncrypt");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "useRandomIV", "useRandomIV");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "keystorePath", "keystorePath");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "keystorePassword", "keystorePassword");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "keyPassword", "keyPassword");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "algorithm", "algorithm");
                this.parseProperty(jceEncrypterConfigBuilder, jceEncrypterConfigChildElement, "encryptionMode", "encryptionMode");
                builder.addPropertyValue("jceEncrypterConfig", (Object)jceEncrypterConfigBuilder.getBeanDefinition());
            }
        }
        if (!this.parseNoExprObjectRef(element, builder, "pgp-encrypter-config", "pgpEncrypterConfig")) {
            BeanDefinitionBuilder pgpEncrypterConfigBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PGPEncrypterConfiguration.class.getName());
            Element pgpEncrypterConfigChildElement = DomUtils.getChildElementByTagName((Element)element, (String)"pgp-encrypter-config");
            if (pgpEncrypterConfigChildElement != null) {
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "publicKeyRingFileName", "publicKeyRingFileName");
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "secretKeyRingFileName", "secretKeyRingFileName");
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "secretAliasId", "secretAliasId");
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "secretPassphrase", "secretPassphrase");
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "principal", "principal");
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "encryptionAlgorithm", "encryptionAlgorithm");
                this.parseProperty(pgpEncrypterConfigBuilder, pgpEncrypterConfigChildElement, "outputMode", "outputMode");
                builder.addPropertyValue("pgpEncrypterConfig", (Object)pgpEncrypterConfigBuilder.getBeanDefinition());
            }
        }
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        this.setNoRecurseOnDefinition((BeanDefinition)definition);
        return definition;
    }

    private BeanDefinitionBuilder getBeanDefinitionBuilder(ParserContext parserContext) {
        try {
            return BeanDefinitionBuilder.rootBeanDefinition((String)EncryptionModuleLicenseChecker.class.getName());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String muleVersion = "";
            try {
                muleVersion = MuleManifest.getProductVersion();
            }
            catch (Exception _x) {
                logger.error("Problem while reading mule version");
            }
            logger.error("Cannot launch the mule app, the configuration [config] within the connector [encryption] is not supported in mule " + muleVersion);
            throw new BeanDefinitionParsingException(new Problem("Cannot launch the mule app, the configuration [config] within the connector [encryption] is not supported in mule " + muleVersion, new Location(parserContext.getReaderContext().getResource()), null, (Throwable)noClassDefFoundError));
        }
    }
}

