/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.encrypters;

import org.mule.modules.security.encryption.encrypters.XmlEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.XmlEncrypterOverrideConfiguration;
import org.mule.security.encryption.xml.XmlEncrypter;
import org.mule.security.encryption.xml.XmlEncryptionAlgorithm;
import org.mule.security.utils.XMLUtils;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;
import org.mule.security.utils.keyfactories.KeystoreEncryptionKeyFactory;
import org.mule.security.utils.keyfactories.SymmetricEncryptionKeyFactory;
import org.w3c.dom.Document;

public class XmlEncrypterModule {
    private XmlEncrypterConfiguration defaultConfiguration;
    private XmlEncrypterOverrideConfiguration overrideConfiguration;

    public XmlEncrypterModule(XmlEncrypterConfiguration defaultConfiguration, XmlEncrypterOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public byte[] encrypt(byte[] input) {
        try {
            return XMLUtils.createXmlUsing((Document)this.buildXmlEncrypter(this.getKeyPasswordToUse(), this.getKeyToUse()).encrypt(XMLUtils.documentBasedOnThe((byte[])input), this.xpath()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not encrypt the xml", e);
        }
    }

    public byte[] decrypt(byte[] message) {
        try {
            return XMLUtils.createXmlUsing((Document)this.buildXmlEncrypter(this.getKeyPasswordToUse(), this.getKeyToUse()).decrypt(XMLUtils.documentBasedOnThe((byte[])message)));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not encrypt the XML_ENCRYPTER message", e);
        }
    }

    private String xpath() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getXpath() != null) {
            return this.overrideConfiguration.getXpath();
        }
        return this.defaultConfiguration.getXpath();
    }

    private XmlEncrypter buildXmlEncrypter(String keyPassword, String key) {
        XmlEncryptionAlgorithm algorithm = this.algorithm();
        if (this.keystorePath() != null) {
            return new XmlEncrypter(algorithm, (EncryptionKeyFactory)new KeystoreEncryptionKeyFactory(this.keystorePath(), this.keystorePassword(), keyPassword, key, true));
        }
        return new XmlEncrypter(algorithm, (EncryptionKeyFactory)new SymmetricEncryptionKeyFactory(algorithm.getAlgorithm(), key));
    }

    private String getKeyPasswordToUse() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKeyPassword() != null) {
            return this.overrideConfiguration.getKeyPassword();
        }
        return this.defaultConfiguration.getKeyPassword();
    }

    private String getKeyToUse() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getKey() != null) {
            return this.overrideConfiguration.getKey();
        }
        return this.defaultConfiguration.getKey();
    }

    private String keystorePath() {
        return this.defaultConfiguration.getKeystorePath();
    }

    private String keystorePassword() {
        return this.defaultConfiguration.getKeystorePassword();
    }

    private XmlEncryptionAlgorithm algorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getAlgorithm() != null) {
            return this.overrideConfiguration.getAlgorithm();
        }
        return this.defaultConfiguration.getAlgorithm();
    }
}

