/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.language;

import org.mule.modules.security.encryption.encrypters.JCEEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterModule;
import org.mule.modules.security.encryption.encrypters.JCEEncrypterOverrideConfiguration;
import org.mule.security.encryption.MuleEncryptionException;

public class JCEEncrypterModuleWrapper {
    private JCEEncrypterConfiguration defaultConfiguration;

    public JCEEncrypterModuleWrapper(JCEEncrypterConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public Object encrypt(Object payload, String key) throws MuleEncryptionException {
        JCEEncrypterOverrideConfiguration overrideConfiguration = new JCEEncrypterOverrideConfiguration();
        overrideConfiguration.setKey(key);
        return new JCEEncrypterModule(this.defaultConfiguration, overrideConfiguration).encrypt(payload);
    }

    public Object encrypt(Object payload, String key, String keyPassword) throws MuleEncryptionException {
        JCEEncrypterOverrideConfiguration overrideConfiguration = new JCEEncrypterOverrideConfiguration();
        overrideConfiguration.setKey(key);
        overrideConfiguration.setKeyPassword(keyPassword);
        return new JCEEncrypterModule(this.defaultConfiguration, overrideConfiguration).encrypt(payload);
    }

    public Object encrypt(Object payload) throws MuleEncryptionException {
        return new JCEEncrypterModule(this.defaultConfiguration, null).encrypt(payload);
    }

    public Object decrypt(Object payload, String key, String keyPassword) throws MuleEncryptionException {
        JCEEncrypterOverrideConfiguration overrideConfiguration = new JCEEncrypterOverrideConfiguration();
        overrideConfiguration.setKey(key);
        overrideConfiguration.setKeyPassword(keyPassword);
        return new JCEEncrypterModule(this.defaultConfiguration, overrideConfiguration).decrypt(payload);
    }

    public Object decrypt(Object payload, String key) throws MuleEncryptionException {
        JCEEncrypterOverrideConfiguration overrideConfiguration = new JCEEncrypterOverrideConfiguration();
        overrideConfiguration.setKey(key);
        return new JCEEncrypterModule(this.defaultConfiguration, overrideConfiguration).decrypt(payload);
    }

    public Object decrypt(Object payload) throws MuleEncryptionException {
        return new JCEEncrypterModule(this.defaultConfiguration, null).decrypt(payload);
    }
}

