/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.security.encryption.language;

import org.mule.modules.security.encryption.encrypters.PGPEncrypterConfiguration;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterModule;
import org.mule.modules.security.encryption.encrypters.PGPEncrypterOverrideConfiguration;
import org.mule.security.encryption.MuleEncryptionException;

public class PGPEncrypterModuleWrapper {
    private PGPEncrypterConfiguration defaultConfiguration;

    public PGPEncrypterModuleWrapper(PGPEncrypterConfiguration pgpEncrypter) {
        this.defaultConfiguration = pgpEncrypter;
    }

    public Object encrypt(Object payload) throws MuleEncryptionException {
        return new PGPEncrypterModule(this.defaultConfiguration, null).encrypt(payload);
    }

    public Object encrypt(Object payload, String principal) throws MuleEncryptionException {
        PGPEncrypterOverrideConfiguration overrideConfiguration = new PGPEncrypterOverrideConfiguration();
        overrideConfiguration.setPrincipal(principal);
        return new PGPEncrypterModule(this.defaultConfiguration, overrideConfiguration).encrypt(payload);
    }

    public Object decrypt(Object payload, String principal) throws MuleEncryptionException {
        PGPEncrypterOverrideConfiguration overrideConfiguration = new PGPEncrypterOverrideConfiguration();
        overrideConfiguration.setPrincipal(principal);
        return new PGPEncrypterModule(this.defaultConfiguration, overrideConfiguration).decrypt(payload);
    }

    public Object decrypt(Object payload) throws MuleEncryptionException {
        return new PGPEncrypterModule(this.defaultConfiguration, null).decrypt(payload);
    }
}

