/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.config;

import org.mule.config.MuleManifest;
import org.mule.module.signature.config.SignDefinitionParser;
import org.mule.module.signature.config.SignXmlDefinitionParser;
import org.mule.module.signature.config.SignatureModuleConfigDefinitionParser;
import org.mule.module.signature.config.VerifySignatureDefinitionParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class SignatureNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(SignatureNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [signature] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [signature] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new SignatureModuleConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("sign", (BeanDefinitionParser)new SignDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("sign", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("sign-xml", (BeanDefinitionParser)new SignXmlDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("sign-xml", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("verify-signature", (BeanDefinitionParser)new VerifySignatureDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("verify-signature", "@Processor", ex);
        }
    }
}

