/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.signature.signers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.encoders.Base64;
import org.mule.RequestContext;
import org.mule.api.transport.OutputHandler;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.module.signature.signers.PGPSignerConfiguration;
import org.mule.module.signature.signers.PGPSignerOverrideConfiguration;
import org.mule.security.signature.pgp.PGPSigner;
import org.mule.security.signature.pgp.algorithms.PGPSignatureAlgorithm;

public class PGPSignerModule {
    public static final String PGP_SIGNATURE_HEADER = "-----BEGIN PGP SIGNATURE-----";
    public static final String PGP_SIGNATURE_FOOTER = "-----END PGP SIGNATURE-----\n";
    private final PGPSignerConfiguration defaultConfiguration;
    private final PGPSignerOverrideConfiguration overrideConfiguration;

    public PGPSignerModule(PGPSignerConfiguration defaultConfiguration, PGPSignerOverrideConfiguration overrideConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
        this.overrideConfiguration = overrideConfiguration;
    }

    public Object sign(Object input) throws PGPException {
        if (input instanceof byte[]) {
            return new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).sign((byte[])input);
        }
        if (input instanceof InputStream) {
            return new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).sign((InputStream)input);
        }
        if (input instanceof OutputHandler) {
            InputStream inputStream;
            ByteArrayInputStream is = null;
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ((OutputHandler)input).write(RequestContext.getEvent(), (OutputStream)bytes);
                is = new ByteArrayInputStream(bytes.toByteArray());
                inputStream = new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).sign((InputStream)is);
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeException("Could not sign the data. The input was unreadable.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return inputStream;
        }
        if (input instanceof String) {
            return new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).sign(((String)input).getBytes());
        }
        throw new RuntimeException("Could not sign the input. The input has to be a byte array, Input Stream or String");
    }

    private PGPSignatureAlgorithm getAlgorithm() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getAlgorithm() != null) {
            return this.overrideConfiguration.getAlgorithm();
        }
        return this.defaultConfiguration.getAlgorithm();
    }

    public boolean validateSignature(Object input, Object expectedSignature) throws Exception {
        InputStream transformedExpectedSignature = this.transformExpectedSignature(expectedSignature);
        if (input instanceof byte[]) {
            return new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).validateSignature((byte[])input, transformedExpectedSignature);
        }
        if (input instanceof InputStream) {
            return new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).validateSignature((InputStream)input, transformedExpectedSignature);
        }
        if (input instanceof OutputHandler) {
            boolean bl;
            ByteArrayInputStream is = null;
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ((OutputHandler)input).write(RequestContext.getEvent(), (OutputStream)bytes);
                is = new ByteArrayInputStream(bytes.toByteArray());
                bl = new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).validateSignature((InputStream)is, transformedExpectedSignature);
            }
            catch (IOException ex) {
                try {
                    throw new RuntimeException("Could not verify the data. The input was unreadable.");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
            return bl;
        }
        if (input instanceof String) {
            return new PGPSigner(this.publicKeyFile(), this.privateKeyFile(), this.aliasId(), this.passphrase(), this.getAlgorithm(), this.outputMode()).validateSignature(((String)input).getBytes(), transformedExpectedSignature);
        }
        throw new RuntimeException("Could not verify the input. The input has to be a byte array, Input Stream or String");
    }

    private String passphrase() {
        return this.defaultConfiguration.getSecretPassphrase();
    }

    private String aliasId() {
        return this.defaultConfiguration.getSecretAliasId();
    }

    private String privateKeyFile() {
        return this.defaultConfiguration.getSecretKeyRingFileName();
    }

    private PGPOutputMode outputMode() {
        if (this.overrideConfiguration != null && this.overrideConfiguration.getOutputMode() != null) {
            return this.overrideConfiguration.getOutputMode();
        }
        return this.defaultConfiguration.getOutputMode();
    }

    private String publicKeyFile() {
        return this.defaultConfiguration.getPublicKeyRingFileName();
    }

    private InputStream transformExpectedSignature(Object expectedSignature) throws PGPException {
        if (expectedSignature instanceof String) {
            String stringExpectedSignature = (String)expectedSignature;
            if (stringExpectedSignature.startsWith(PGP_SIGNATURE_HEADER)) {
                return new ByteArrayInputStream(stringExpectedSignature.getBytes());
            }
            return new ByteArrayInputStream(Base64.decode((String)stringExpectedSignature));
        }
        if (expectedSignature instanceof InputStream) {
            return (InputStream)expectedSignature;
        }
        if (expectedSignature instanceof byte[]) {
            return new ByteArrayInputStream((byte[])expectedSignature);
        }
        throw new PGPException("Unsupported type for expected signature " + expectedSignature.getClass());
    }
}

