/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.encryption.binary.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.CredentialsAccessor;
import org.mule.api.security.CryptoFailureException;
import org.mule.module.pgp.KeyBasedEncryptionStrategy;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.security.encryption.MuleEncryptionException;
import org.mule.security.encryption.binary.Encrypter;

public class PGPEncrypter
implements Encrypter {
    protected static final Log logger = LogFactory.getLog(PGPEncrypter.class);
    private PGPKeyRing pgpKeyRing;
    private EncryptionStrategy encryptionStrategy;

    public PGPEncrypter(String publicKeyFile, String privateKeyFile, String aliasId, String passPhrase, String fileName, final String principal, String encryptionAlgorithm, PGPOutputMode pgpOutputMode) {
        if (principal == null) {
            throw new IllegalArgumentException("A principal must be defined for PGP encryption");
        }
        this.pgpKeyRing = this.buildPgpKeyRing(publicKeyFile, privateKeyFile, aliasId, passPhrase);
        KeyBasedEncryptionStrategy encryptionStrategy = new KeyBasedEncryptionStrategy();
        encryptionStrategy.setCheckKeyExpirity(true);
        encryptionStrategy.setKeyManager(this.pgpKeyRing);
        this.setEncryptionFilenameIfPossible(encryptionStrategy, fileName);
        encryptionStrategy.setPgpOutputMode(pgpOutputMode);
        encryptionStrategy.setCredentialsAccessor(new CredentialsAccessor(){

            public Object getCredentials(MuleEvent event) {
                return principal;
            }

            public void setCredentials(MuleEvent event, Object credentials) {
            }
        });
        encryptionStrategy.setEncryptionAlgorithm(encryptionAlgorithm);
        try {
            encryptionStrategy.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException("Could not initialise encryption strategy", e);
        }
        this.encryptionStrategy = encryptionStrategy;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] encrypt(byte[] data) throws MuleEncryptionException {
        byte[] byArray;
        InputStream encrypted = null;
        try {
            encrypted = this.encryptionStrategy.encrypt((InputStream)new ByteArrayInputStream(data), null);
            byArray = IOUtils.toByteArray((InputStream)encrypted);
        }
        catch (CryptoFailureException e) {
            try {
                throw new MuleEncryptionException("Could not encrypt the data", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MuleEncryptionException("Could not encrypt the data", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(encrypted);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)encrypted);
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void encrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        InputStream encrypted = null;
        try {
            encrypted = this.encryptionStrategy.encrypt(in, null);
            IOUtils.copyLarge((InputStream)encrypted, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new MuleEncryptionException("Could not encrypt the data", e);
                catch (CryptoFailureException e2) {
                    throw new MuleEncryptionException("Could not encrypt the data", (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(encrypted);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)encrypted);
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] decrypt(byte[] data) throws MuleEncryptionException {
        byte[] byArray;
        InputStream io = null;
        try {
            io = this.encryptionStrategy.decrypt((InputStream)new ByteArrayInputStream(data), null);
            byArray = IOUtils.toByteArray((InputStream)io);
        }
        catch (CryptoFailureException e) {
            try {
                throw new MuleEncryptionException("Could not decrypt the data", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MuleEncryptionException("Could not decrypt the data", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(io);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)io);
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void decrypt(InputStream in, OutputStream out) throws MuleEncryptionException {
        InputStream decrypted = null;
        try {
            decrypted = this.encryptionStrategy.decrypt(in, null);
            IOUtils.copyLarge((InputStream)decrypted, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new MuleEncryptionException("Could not decrypt the data", e);
                catch (CryptoFailureException e2) {
                    throw new MuleEncryptionException("Could not decrypt the data", (Exception)((Object)e2));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(decrypted);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)decrypted);
        IOUtils.closeQuietly((InputStream)in);
    }

    private PGPKeyRing buildPgpKeyRing(String publicKeyFile, String privateKeyFile, String aliasId, String passPhrase) {
        try {
            PGPKeyRingImpl pgpKeyRing = new PGPKeyRingImpl();
            pgpKeyRing.setPublicKeyRingFileName(publicKeyFile);
            pgpKeyRing.setSecretKeyRingFileName(privateKeyFile);
            pgpKeyRing.setSecretAliasId(aliasId);
            pgpKeyRing.setSecretPassphrase(passPhrase);
            pgpKeyRing.initialise();
            return pgpKeyRing;
        }
        catch (InitialisationException e) {
            return null;
        }
    }

    public void setEncryptionStrategy(EncryptionStrategy encryptionStrategy) {
        this.encryptionStrategy = encryptionStrategy;
    }

    private void setEncryptionFilenameIfPossible(KeyBasedEncryptionStrategy strategy, String fileName) {
        Method methodToSetFileName = null;
        try {
            methodToSetFileName = KeyBasedEncryptionStrategy.class.getMethod("setFileName", String.class);
            methodToSetFileName.invoke((Object)strategy, fileName);
        }
        catch (Exception e) {
            logger.warn((Object)"Mule version may have no support for setting the PGP encrypted filename. PGP will encrypt the input using \"stream\" as filename.");
        }
    }
}

