/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.data;

import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import org.bouncycastle.util.encoders.Base64;
import org.mule.security.encryption.NotSupportedInFipsModeException;
import org.mule.security.signature.data.Signer;
import org.mule.security.utils.AESFactory;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;

public class DigitalSigner
implements Signer {
    private String signatureAlgorithm;
    private EncryptionKeyFactory factory;

    public DigitalSigner(String signatureAlgorithm, EncryptionKeyFactory factory) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.factory = factory;
    }

    @Override
    public String sign(byte[] data) {
        Signature signature = null;
        try {
            signature = this.getSignature();
            Key privateKey = this.factory.buildEncryptionKey();
            signature.initSign((PrivateKey)privateKey, new SecureRandom());
            signature.update(data);
            byte[] sigBytes = signature.sign();
            byte[] encode = Base64.encode((byte[])sigBytes);
            return new String(encode);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.wrap(e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign the data ", e);
        }
    }

    @Override
    public String sign(InputStream stream) {
        Signature signature = null;
        try {
            signature = this.getSignature();
            Key privateKey = this.factory.buildEncryptionKey();
            signature.initSign((PrivateKey)privateKey, new SecureRandom());
            byte[] buffer = new byte[1024];
            int read = -1;
            while (stream.available() > 0) {
                read = stream.read(buffer, 0, buffer.length);
                signature.update(buffer, 0, read);
            }
            byte[] sigBytes = signature.sign();
            byte[] encode = Base64.encode((byte[])sigBytes);
            return new String(encode);
        }
        catch (NoSuchAlgorithmException e) {
            throw this.wrap(e);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not sign the data ", e);
        }
    }

    @Override
    public boolean validateSignature(byte[] data, String expectedSignature) {
        try {
            Signature signature = this.getSignature();
            Key privateKey = this.factory.buildDecryptionKey();
            signature.initVerify((PublicKey)privateKey);
            signature.update(data);
            return signature.verify(Base64.decode((String)expectedSignature));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not validate the signature", e);
        }
    }

    @Override
    public boolean validateSignature(InputStream stream, String expectedSignature) {
        try {
            Signature signature = this.getSignature();
            Key privateKey = this.factory.buildDecryptionKey();
            signature.initVerify((PublicKey)privateKey);
            byte[] buffer = new byte[1024];
            int read = -1;
            while (stream.available() > 0) {
                read = stream.read(buffer, 0, buffer.length);
                signature.update(buffer, 0, read);
            }
            return signature.verify(Base64.decode((String)expectedSignature));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not validate the signature", e);
        }
    }

    private RuntimeException wrap(NoSuchAlgorithmException e) {
        if (AESFactory.isFipsEnabled()) {
            return new RuntimeException("Could not sign data", new NotSupportedInFipsModeException(String.format("Could not find digital signature algorithm '%s'. You're running in FIPS mode  so please verify that algorithm is compliant with FIPS.", this.signatureAlgorithm), e));
        }
        return new RuntimeException(String.format("Could not find digital signature algorithm '%s'.", this.signatureAlgorithm, e));
    }

    private Signature getSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
        return AESFactory.getSignature(this.signatureAlgorithm);
    }
}

