/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.data.algorithms;

import org.mule.security.signature.data.Signer;
import org.mule.security.signature.data.factories.DigitalSignerFactory;
import org.mule.security.signature.data.factories.HMACSignerFactory;
import org.mule.security.signature.data.factories.SignerFactory;
import org.mule.security.utils.keyfactories.AsymmetricEncryptionKeyFactory;
import org.mule.security.utils.keyfactories.KeystoreEncryptionKeyFactory;
import org.mule.security.utils.keyfactories.SymmetricEncryptionKeyFactory;

public enum DataSignatureAlgorithm {
    MD2WithRSAEncryption(new DigitalSignerFactory("MD2WithRSAEncryption"), "RSA", false),
    MD4WithRSAEncryption(new DigitalSignerFactory("MD4WithRSAEncryption"), "RSA", false),
    MD5WithRSAEncryption(new DigitalSignerFactory("MD5WithRSAEncryption"), "RSA", false),
    RIPEMD128WithRSAEncryption(new DigitalSignerFactory("RIPEMD128WithRSAEncryption"), "RSA", false),
    RIPEMD160WithRSAEncryption(new DigitalSignerFactory("RIPEMD160WithRSAEncryption"), "RSA", false),
    RIPEMD256WithRSAEncryption(new DigitalSignerFactory("RIPEMD256WithRSAEncryption"), "RSA", false),
    SHA1WithRSAEncryption(new DigitalSignerFactory("SHA1WithRSAEncryption"), "RSA", false),
    SHA224WithRSAEncryption(new DigitalSignerFactory("SHA224WithRSAEncryption"), "RSA", false),
    SHA256WithRSAEncryption(new DigitalSignerFactory("SHA256WithRSAEncryption"), "RSA", false),
    SHA512WithRSAEncryption(new DigitalSignerFactory("SHA512WithRSAEncryption"), "RSA", false),
    HmacSHA1(new HMACSignerFactory("HmacSHA1"), "HmacSHA1", true),
    HmacSHA256(new HMACSignerFactory("HmacSHA256"), "HmacSHA256", true),
    HmacSHA384(new HMACSignerFactory("HmacSHA384"), "HmacSHA384", true),
    HmacSHA512(new HMACSignerFactory("HmacSHA512"), "HmacSHA512", true),
    HmacMD5(new HMACSignerFactory("HmacMD5"), "HmacMD5", true);

    private SignerFactory factory;
    private String algorithm;
    private boolean symmetric;

    private DataSignatureAlgorithm(SignerFactory factory, String algorithm, boolean symmetric) {
        this.factory = factory;
        this.algorithm = algorithm;
        this.symmetric = symmetric;
    }

    public Signer getKeystoreSigner(String keystorePath, String keystorePassword, String keyPassword, String key) {
        return this.factory.create(new KeystoreEncryptionKeyFactory(keystorePath, keystorePassword, keyPassword, key, this.symmetric));
    }

    public Signer getPlainSigner(String key) {
        if (this.symmetric) {
            return this.factory.create(new SymmetricEncryptionKeyFactory(this.algorithm, key));
        }
        return this.factory.create(new AsymmetricEncryptionKeyFactory(this.algorithm, key, false));
    }
}

