/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.PGPKeyRingImpl;
import org.mule.module.pgp.config.PGPOutputMode;
import org.mule.module.pgp.util.BouncyCastleUtil;
import org.mule.security.signature.pgp.algorithms.PGPSignatureAlgorithm;
import org.mule.util.SecurityUtils;

public class PGPSigner {
    public static final String SIGNATURE_NOT_FOUND_KEY = "Message was signed for keyID %s, that is not available in the given key ring";
    private final PGPSignatureAlgorithm algorithm;
    private final PGPKeyRing keyRing;
    private final PGPOutputMode outputMode;
    private final String aliasId;
    private final ByteArrayOutputStream result = new ByteArrayOutputStream();

    public PGPSigner(String publicKeyFile, String privateKeyFile, String aliasId, String passPhrase, PGPSignatureAlgorithm algorithm, PGPOutputMode outputMode) {
        if (!SecurityUtils.isFipsSecurityModel()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.aliasId = aliasId;
        this.outputMode = outputMode;
        this.algorithm = algorithm;
        this.keyRing = this.buildPgpKeyRing(publicKeyFile, privateKeyFile, aliasId, passPhrase);
    }

    public InputStream sign(byte[] data) throws PGPException {
        Object outputStream = this.outputMode == PGPOutputMode.ARMOR ? new ArmoredOutputStream((OutputStream)this.result) : this.result;
        PGPPrivateKey pgpPrivateKey = this.getSecretKey();
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new JcaPGPContentSignerBuilder(pgpPrivateKey.getPublicKeyPacket().getAlgorithm(), this.algorithm.getNumericId()).setProvider("BC"));
        signatureGenerator.init(0, pgpPrivateKey);
        BCPGOutputStream bcpgOutputStream = new BCPGOutputStream((OutputStream)outputStream);
        signatureGenerator.update(data);
        try {
            signatureGenerator.generate().encode((OutputStream)bcpgOutputStream);
            IOUtils.closeQuietly((OutputStream)bcpgOutputStream);
            return new ByteArrayInputStream(this.result.toByteArray());
        }
        catch (Exception e) {
            throw new PGPException("Could not sign the data " + e);
        }
    }

    public InputStream sign(InputStream stream) throws PGPException {
        byte[] data;
        try {
            data = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw new PGPException("Could not sign the data " + e);
        }
        return this.sign(data);
    }

    public boolean validateSignature(InputStream input, InputStream expectedSignature) throws Exception {
        byte[] data = IOUtils.toByteArray((InputStream)input);
        return this.validateSignature(data, expectedSignature);
    }

    public boolean validateSignature(byte[] input, InputStream expectedSignature) throws Exception {
        PGPSignatureList pgpSigList;
        InputStream sigInputStream = PGPUtil.getDecoderStream((InputStream)expectedSignature);
        JcaPGPObjectFactory pgpObjFactory = new JcaPGPObjectFactory(sigInputStream);
        Object obj = pgpObjFactory.nextObject();
        if (obj instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)obj;
            pgpObjFactory = new PGPObjectFactory(c1.getDataStream(), null);
            pgpSigList = (PGPSignatureList)pgpObjFactory.nextObject();
        } else {
            pgpSigList = (PGPSignatureList)obj;
        }
        PGPSignature sig = pgpSigList.get(0);
        PGPPublicKey pubKey = this.getPublicKey(sig.getKeyID());
        sig.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), pubKey);
        sig.update(input);
        sigInputStream.close();
        return sig.verify();
    }

    private PGPKeyRing buildPgpKeyRing(String publicKeyFile, String privateKeyFile, String aliasId, String passPhrase) {
        PGPKeyRingImpl pgpKeyRing = new PGPKeyRingImpl();
        pgpKeyRing.setPublicKeyRingFileName(publicKeyFile);
        pgpKeyRing.setSecretKeyRingFileName(privateKeyFile);
        pgpKeyRing.setSecretAliasId(aliasId);
        pgpKeyRing.setSecretPassphrase(passPhrase);
        try {
            pgpKeyRing.initialise();
        }
        catch (InitialisationException initialisationException) {
            throw new RuntimeException("Could not initialise PGPKeyRing", initialisationException);
        }
        return pgpKeyRing;
    }

    private PGPPrivateKey getSecretKey() throws PGPException {
        if (this.aliasId == null) {
            throw new IllegalStateException("AliasId can not be null. It is necessary to sign the message");
        }
        PGPSecretKey secretKey = this.keyRing.getConfiguredSecretKey();
        String secretPassPhrase = this.keyRing.getSecretPassphrase();
        return secretKey.extractPrivateKey(BouncyCastleUtil.PBE_SECRET_KEY_DECRYPTOR_BUILDER.build(secretPassPhrase.toCharArray()));
    }

    private PGPPublicKey getPublicKey(long keyId) throws PGPException {
        PGPPublicKey publicKey = this.keyRing.getPublicKeys().getPublicKey(keyId);
        if (publicKey == null) {
            throw new PGPException(String.format(SIGNATURE_NOT_FOUND_KEY, Long.toHexString(keyId).toUpperCase()));
        }
        return publicKey;
    }
}

