/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml;

import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;
import org.mule.security.signature.xml.reference.SignatureContextProvider;

public class Signer {
    public static XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
    private KeyInfoProvider keyInfoProvider;
    private SignatureContextProvider signatureContextProvider;

    public Signer(KeyInfoProvider keyInfoProvider, SignatureContextProvider signatureContextProvider) {
        this.keyInfoProvider = keyInfoProvider;
        this.signatureContextProvider = signatureContextProvider;
    }

    public void sign() {
        try {
            Reference reference = this.signatureContextProvider.getReference();
            XMLSignature signature = fac.newXMLSignature(this.keyInfoProvider.getSignedInfo(reference), this.keyInfoProvider.getKeyInfo(), this.signatureContextProvider.getReferencedObjects(), null, null);
            DOMSignContext signContext = new DOMSignContext(this.keyInfoProvider.getSecretKey(), this.signatureContextProvider.getSignatureParentNode());
            signContext.setDefaultNamespacePrefix("dsig");
            signature.sign(signContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add Signature to the document", e);
        }
    }
}

