/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.keyinfo;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;

public class KeyPairInfoProvider
implements KeyInfoProvider {
    private KeyPair keyPair;
    private CanonicalizationAlgorithm canonicalizationAlgorithm;
    private String keyPairAlgorithm;

    public KeyPairInfoProvider(CanonicalizationAlgorithm canonicalizationAlgorithm, String keyPairAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        this.keyPairAlgorithm = keyPairAlgorithm;
        try {
            this.keyPair = this.keyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not getReference DSA org.mule.security.encryption.xml pair", e);
        }
    }

    @Override
    public KeyInfo getKeyInfo() {
        try {
            KeyInfoFactory kif = Signer.fac.getKeyInfoFactory();
            KeyValue kv = kif.newKeyValue(this.keyPair.getPublic());
            return kif.newKeyInfo(Collections.singletonList(kv));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not getReference DSA Key Info", e);
        }
    }

    @Override
    public Key getSecretKey() {
        return this.keyPair.getPrivate();
    }

    @Override
    public SignedInfo getSignedInfo(Reference ref) {
        try {
            return Signer.fac.newSignedInfo(Signer.fac.newCanonicalizationMethod(this.canonicalizationAlgorithm.getAlgorithm(), (C14NMethodParameterSpec)null), Signer.fac.newSignatureMethod(this.getSignatureMethod(), null), Collections.singletonList(ref));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating DSA Signed Info", e);
        }
    }

    private KeyPair keyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.keyPairAlgorithm);
        kpg.initialize(512);
        return kpg.generateKeyPair();
    }

    public String getSignatureMethod() {
        if (this.keyPairAlgorithm.equals("DSA")) {
            return SignatureMethodAlgorithm.DSA_SHA1.getAlgorithm();
        }
        if (this.keyPairAlgorithm.equals("RSA")) {
            return SignatureMethodAlgorithm.RSA_SHA1.getAlgorithm();
        }
        throw new RuntimeException("Invalid algorithm");
    }
}

