/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.keyinfo;

import java.security.Key;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.CanonicalizationAlgorithm;
import org.mule.security.signature.xml.algorithms.SignatureMethodAlgorithm;
import org.mule.security.signature.xml.keyinfo.KeyInfoProvider;
import org.mule.util.IOUtils;

public class X509KeyInfoProvider
implements KeyInfoProvider {
    private KeyStore.PrivateKeyEntry keyEntry;
    private CanonicalizationAlgorithm canonicalizationAlgorithm;
    private SignatureMethodAlgorithm signatureMethod;

    public X509KeyInfoProvider(CanonicalizationAlgorithm canonicalizationAlgorithm, SignatureMethodAlgorithm signatureMethod, String keystore, String keystorePassword, String key, String keyPassword) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        this.signatureMethod = signatureMethod;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(IOUtils.getResourceAsStream((String)keystore, this.getClass()), keystorePassword.toCharArray());
            this.keyEntry = (KeyStore.PrivateKeyEntry)ks.getEntry(key, new KeyStore.PasswordProtection(keyPassword.toCharArray()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read the keystore", e);
        }
    }

    @Override
    public KeyInfo getKeyInfo() {
        X509Certificate cert = (X509Certificate)this.keyEntry.getCertificate();
        KeyInfoFactory kif = Signer.fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(cert.getSubjectX500Principal().getName());
        x509Content.add(cert);
        X509Data xd = kif.newX509Data(x509Content);
        return kif.newKeyInfo(Collections.singletonList(xd));
    }

    @Override
    public Key getSecretKey() {
        return this.keyEntry.getPrivateKey();
    }

    @Override
    public SignedInfo getSignedInfo(Reference ref) {
        try {
            return Signer.fac.newSignedInfo(Signer.fac.newCanonicalizationMethod(this.canonicalizationAlgorithm.getAlgorithm(), (C14NMethodParameterSpec)null), Signer.fac.newSignatureMethod(this.signatureMethod.getAlgorithm(), null), Collections.singletonList(ref));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create signed info for X509 Signature", e);
        }
    }
}

