/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.algorithms.DigestMethodAlgorithm;
import org.mule.security.signature.xml.reference.SignatureContextProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EnvelopingSignatureContextProvider
implements SignatureContextProvider {
    private DigestMethodAlgorithm digestMethodAlgorithm;
    private Document document;

    public EnvelopingSignatureContextProvider(DigestMethodAlgorithm digestMethodAlgorithm, Document document) {
        this.digestMethodAlgorithm = digestMethodAlgorithm;
        this.document = document;
    }

    @Override
    public Reference getReference() {
        try {
            return Signer.fac.newReference("#data", Signer.fac.newDigestMethod(this.digestMethodAlgorithm.getAlgorithm(), null));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not getReference Enveloping Reference", e);
        }
    }

    @Override
    public List<Object> getReferencedObjects() {
        ArrayList<Object> objects = new ArrayList<Object>();
        DOMStructure structure = new DOMStructure(this.document.getDocumentElement());
        objects.add(Signer.fac.newXMLObject(Collections.singletonList(structure), "data", null, "UTF-8"));
        return objects;
    }

    @Override
    public Node getSignatureParentNode() {
        return this.document;
    }
}

