/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.signature.xml.validator;

import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.mule.security.signature.xml.Signer;
import org.mule.security.signature.xml.validator.SignatureValidator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class SecretKeyValidator
implements SignatureValidator {
    private String key;
    private String keyAlgorithm;

    public SecretKeyValidator(String keyAlgorithm, String key) {
        this.keyAlgorithm = keyAlgorithm;
        this.key = key;
    }

    @Override
    public boolean validate(Document doc) throws MarshalException, XMLSignatureException {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new RuntimeException("Cannot find Signature element");
        }
        DOMValidateContext valContext = new DOMValidateContext(new SecretKeySpec(this.key.getBytes(), this.keyAlgorithm), nl.item(0));
        XMLSignature signature = Signer.fac.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }
}

