/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.utils.keyfactories;

import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.util.encoders.Base64;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;

public class AsymmetricEncryptionKeyFactory
implements EncryptionKeyFactory {
    private String algorithm;
    private String key;
    private boolean usePublicKeyToEncrypt;

    public AsymmetricEncryptionKeyFactory(String algorithm, String key, boolean usePublicKeyToEncrypt) {
        this.algorithm = algorithm;
        this.key = key;
        this.usePublicKeyToEncrypt = usePublicKeyToEncrypt;
        this.validateKey();
    }

    @Override
    public Key buildEncryptionKey() {
        if (this.usePublicKeyToEncrypt) {
            return this.buildX509EncodedKey();
        }
        return this.buildPKCS8Key();
    }

    private Key buildPKCS8Key() {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.decode((String)this.key));
        try {
            KeyFactory kf = KeyFactory.getInstance(this.algorithm);
            return kf.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build the Encryption key", e);
        }
    }

    @Override
    public Key buildDecryptionKey() {
        if (this.usePublicKeyToEncrypt) {
            return this.buildPKCS8Key();
        }
        return this.buildX509EncodedKey();
    }

    private Key buildX509EncodedKey() {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.decode((String)this.key));
        try {
            KeyFactory kf = KeyFactory.getInstance(this.algorithm);
            return kf.generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build the descryption key", e);
        }
    }

    @Override
    public String getPlainKey() {
        return this.key;
    }

    private void validateKey() {
        if (this.key == null) {
            throw new IllegalArgumentException("If keystore is not defined then the key is considered to be an encryption key in Base64 encoding");
        }
    }
}

