/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.utils.keyfactories;

import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.mule.security.utils.keyfactories.EncryptionKeyFactory;

public class SymmetricEncryptionKeyFactory
implements EncryptionKeyFactory {
    private String algorithm;
    private String key;

    public SymmetricEncryptionKeyFactory(String algorithm, String key) {
        this.algorithm = algorithm;
        this.key = key;
        this.validateKey();
    }

    @Override
    public Key buildEncryptionKey() {
        byte[] bytes = this.key.getBytes();
        return new SecretKeySpec(bytes, this.algorithm);
    }

    @Override
    public Key buildDecryptionKey() {
        return this.buildEncryptionKey();
    }

    @Override
    public String getPlainKey() {
        return this.key;
    }

    private void validateKey() {
        if (this.key == null) {
            throw new IllegalArgumentException("If keystore is not defined then the key is considered to be an encryption key in Base64 encoding");
        }
    }
}

